<?php
/**
 * Aptana Cloud Sample Application - Image Manipulation Demo
 * 
 * This is just a simple, single-page app showing off file uploads and image manipulations using the imagick 
 * extension for PHP.  Feel free to modify this code in any way, or re-use it in one of your apps
 * if you would like.
 * 
 * The basic process followed by the application is:
 * 
 *  - Upload an image file to the 'uploads' directory
 *  - Open the image, and resize it
 *  - Apply some effects via imagick to create a "polaroid" effect
 *  - Save the resulting image
 *  - Show the resulting image to the user
 *  
 * For more information about imagick, check out the PHP docs for the extension:
 * {@link http://us3.php.net/manual/en/intro.imagick.php PHP imagick documentation}
 * 
 * Also see Mikko's blog for the code that inspired this sample, as well as more imagick
 * goodness:
 * {@link http://valokuva.org/?p=42 Mikko's Blog}
 * 
 * @author Ian Selby
 * @version 1.0
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 * @package ImageManipulationDemo
 * @filesource
 */

/**
 * Helper functions for the sample app
 */
include_once('functions.inc.php');

// upload the file if the form has been submitted and then process the image
if(isset($_POST['doUploadFile']))
{
	$result = uploadImage('file2upl');
	
	if($result['success'])
	{
		$new_file = generatePolaroidImage(SITE_ROOT . 'uploads/' . $result['filename']);
	}
}

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Image Manipulation Demo</title>
	
	<style type="text/css">
	
		body { 
			color: #333;
			font-family: "Lucida Grande", Arial, Helvetica, sans;
			font-size: 12px;
			margin: 0;
			padding: 10px;
		}
		
		a { color: #0080ff; }
		
		p { line-height: 16px; }
		
		.footer {
			font-size: 10px;
			line-height: 16px;
			margin-top: 10px;
			text-align: center;
		}
	
	</style>
</head>
<body>

<?php if(!isset($_POST['doUploadFile'])): ?>

<h1>Sample Image Manipulation</h1>

<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
<p>
	<label for="file2upl">Choose a File to Upload:</label><br />
	<input type="file" name="file2upl" id="file2upl" /><br />

	<button type="submit">Submit</button>
	
	<input type="hidden" name="doUploadFile" value="1" />
	

</p>
</form>

<?php else: ?>

	<?php if($result['success']): ?>
	<h1>Uploaded File</h1>
	<img src="uploads/<?php echo $new_file; ?>" />
	<br />
	<a href="index.php">Upload another image...</a>
	
	<?php else: ?>
	<h1>Error</h1>
	<?php echo $result['error']; ?><br />
	<a href="index.php">Try again...</a>
	
	<?php endif; ?>

<?php endif; ?>
	
<div class="footer">
	<a href="docs/index.html">View Documentation and Source for This Sample</a><br />
	<img src="images/studio.png" alt="Aptana Studio" align="absmiddle" /> Built with <a href="http://www.aptana.com/studio" title="Aptana Studio">Aptana Studio</a> 
	| Deployed with <a href="http://www.aptana.com/cloud" title="Aptana Cloud">Aptana Cloud</a> <img src="images/cloud.png" alt="Aptana Cloud" align="absmiddle" />
	
</div>
</body>
</html>